# coding: utf-8
import pandas as pd
import numpy as np
from joblib import load, dump

####################################################################################
####################################################################################
############################# AREA OF INPUT PARAMETERS #############################
####################################################################################
####################################################################################

##### Environment Parameters
PATH = "." # Root directory, should be the same path this "README.md" file locates
PATH_DATA = f"{PATH}/data"  # Path for data
PATH_MODELS = f"{PATH}/models" # Path for models

##### Parameters for Bandits
budget = 1600 # Budget constraint, to reproduce, test with 1600 and 20000
list_seed_simulation = list(range(1989, 1992)) # List of seed tested, to reproduce the results, use 1989, 1990 and 1991

####################################################################################
####################################################################################
############# Load the data and Update the hyperparameters to get eta_OCO ##########
####################################################################################
####################################################################################

##### Load hyperparameters
dict_hyper = load(f"{PATH_MODELS}/budget_{budget}/dict_hyper.pkl")

##### Parameters to be tested
list_C = [0.025, 0.1, 0.3]
list_C_str = ["0" + str(x)[2:] for x in list_C]

list_eta_OCO = [0.005, 0.01, 0.05, 0.1, 0.2]
list_eta_OCO_str = ["0" + str(x)[2:] for x in list_eta_OCO]

##### Find the best eta_OCO per C and Collect the results
dict_results_rewards = {}
dict_results_rewards_std = {}

for C_ in list_C:
    print(C_)
    C_str_ = "0" + str(C_)[2:]
    
    dict_results_C_ = {}
    dict_results_C_std_ = {}
    for eta_OCO_ in list_eta_OCO:
        print(eta_OCO_)
        eta_OCO_str_ = "0" + str(eta_OCO_)[2:]

        for index_, seed_ in enumerate(list_seed_simulation):
            print(seed_)
            linear_bandits_ = \
                load(f"{PATH_MODELS}/budget_{budget}/tuning_random_seed_{seed_}/linear_bandits_eta{eta_OCO_str_}_C{C_str_}.pkl")
            reward_linear_ = np.cumsum(np.array(linear_bandits_.rewards))

            if index_ == 0:
                reward_linear_f = reward_linear_
            else:
                reward_linear_f = np.column_stack([reward_linear_f, reward_linear_])
        
        dict_results_C_[eta_OCO_] = reward_linear_f.max(axis=0).mean()
        dict_results_C_std_[eta_OCO_] = reward_linear_f.max(axis=0).std()
    dict_results_rewards[f"Box D adaptive policy (for linear CBwK) --- C={C_}"] = dict_results_C_
    dict_results_rewards_std[f"Box D adaptive policy (for linear CBwK) --- C={C_}"] = dict_results_C_std_
    print("----------------------------")

table_per_eta_OCO = np.round(pd.DataFrame.from_dict(dict_results_rewards), 2)

dict_eta_OCO = {}
for C_ in list_C:
    dict_eta_OCO[f"{C_}"] = \
        list_eta_OCO[table_per_eta_OCO[f"Box D adaptive policy (for linear CBwK) --- C={C_}"].argmax()]
    
dict_hyper[f"eta_OCO"] = dict_eta_OCO

####################################################################################
####################################################################################
######################### Export Hyperparameters ###################################
####################################################################################
####################################################################################
print(dict_hyper)
dump(dict_hyper, f"{PATH_MODELS}/budget_{budget}/dict_hyper.pkl")

